#include <bits/stdc++.h>
using namespace std;
#define int long long
#define se second
#define fi first
#define lwb lower_bound
#define upb upper_bound
const int N = 1e6, P = 1e9 + 7, INF = 1e18;
mt19937 rnd(time(0));

struct seg {
    pair<int, int> beg, end;

    void assign(pair<int, int> _beg, pair<int, int> _end) {
        beg = _beg;
        end = _end;
    }
};

struct dsu {
    vector<int> p, r;

    void init(int n) {
        p.resize(n);
        r.resize(n, 1);
        iota(p.begin(), p.end(), 0);
    }

    int get(int v) {
        if (v == p[v])
            return v;
        return p[v] = get(p[v]);
    }

    void merge(int a, int b) {
        a = get(a);
        b = get(b);
        if (a == b)
            return;
        if (r[a] < r[b])
            swap(a, b);
        p[b] = a;
        r[a] += r[b];
    }
};

int cross(pair<int, int> a, pair<int, int> b) {
    return a.fi * b.se - b.fi * a.se;
}

pair<int ,int> operator-(pair<int, int> a, pair<int, int> b) {
    pair<int, int> res = {a.fi - b.fi, a.se - b.se};
    return res;
}

bool cr(seg a, seg b) {
    pair<int, int> same = b.end - b.beg,
    fst = a.beg - b.beg, scd = a.end - b.beg;
    int val1 = cross(same, fst) * cross(same, scd);
    same = a.end - a.beg;
    fst = b.beg - a.beg;
    scd = b.end - a.beg;
    int val2 = cross(same, fst) * cross(same, scd);
    return val1 <= 0 && val2 <= 0;
}

void solve() {
    int n;
    cin >> n;
    dsu dsu;
    dsu.init(n);
    int ans = 0;
    vector<seg> a(n);
    for (int i = 0; i < n; i++) {
        int fi1, se1, fi2, se2;
        cin >> fi1 >> se1 >> fi2 >> se2;
        pair<int, int> beg = {fi1, se1}, end = {fi2, se2};
        a[i].assign(beg, end);
        map<int, int> mp;
        for (int j = 0; j < i; j++) {
            if (cr(a[j], a[i])) {
                mp[dsu.get(j)]++;
            }
        }
        for (auto [key, val] : mp) {
            ans += val - 1;
            dsu.merge(i, key);
        }
    }
    cout << ans + 1 << endl;
}

signed main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    int T = 1;
    cin >> T;
    while (T--) {
        solve();
    }
    return 0;
}
